//+------------------------------------------------------------------+
//|                                               Total Strength.mq4 |
//|                                     Copyright  2008, FrantaCech |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, FrantaCech, RUBICON"
#property link      ""

#property indicator_chart_window

extern string Description = "TOTAL STRENGHT:";
extern int PositionFromleft = 105;

double HI_EURUSD,HI_GBPUSD,HI_AUDUSD,HI_USDJPY,HI_USDCHF,HI_USDCAD,HI_EURJPY,HI_EURGBP,HI_EURCHF,HI_EURAUD,HI_GBPJPY,HI_GBPCHF;
double ASK_EURUSD,ASK_GBPUSD,ASK_AUDUSD,ASK_USDJPY,ASK_USDCHF,ASK_USDCAD,ASK_EURJPY,ASK_EURGBP,ASK_EURCHF,ASK_EURAUD,ASK_GBPJPY,ASK_GBPCHF;
double BID_EURUSD,BID_GBPUSD,BID_AUDUSD,BID_USDJPY,BID_USDCHF,BID_USDCAD,BID_EURJPY,BID_EURGBP,BID_EURCHF,BID_EURAUD,BID_GBPJPY,BID_GBPCHF;
double LO_EURUSD,LO_GBPUSD,LO_AUDUSD,LO_USDJPY,LO_USDCHF,LO_USDCAD,LO_EURJPY,LO_EURGBP,LO_EURCHF,LO_EURAUD,LO_GBPJPY,LO_GBPCHF;
double RANGE_EURUSD,RANGE_GBPUSD,RANGE_AUDUSD,RANGE_USDJPY,RANGE_USDCHF,RANGE_USDCAD,RANGE_EURJPY,RANGE_EURGBP,RANGE_EURCHF,RANGE_EURAUD,RANGE_GBPJPY,RANGE_GBPCHF;
double BIDRATIO_EURUSD,BIDRATIO_GBPUSD,BIDRATIO_AUDUSD,BIDRATIO_USDJPY,BIDRATIO_USDCHF,BIDRATIO_USDCAD,BIDRATIO_EURJPY,BIDRATIO_EURGBP,BIDRATIO_EURCHF,BIDRATIO_EURAUD,BIDRATIO_GBPJPY,BIDRATIO_GBPCHF;
double REL_EURUSD,REL_GBPUSD,REL_AUDUSD,REL_USDJPY,REL_USDCHF,REL_USDCAD,REL_EURJPY,REL_EURGBP,REL_EURCHF,REL_EURAUD,REL_GBPJPY,REL_GBPCHF;
double REL2_EURUSD,REL2_GBPUSD,REL2_AUDUSD,REL2_USDJPY,REL2_USDCHF,REL2_USDCAD,REL2_EURJPY,REL2_EURGBP,REL2_EURCHF,REL2_EURAUD,REL2_GBPJPY,REL2_GBPCHF;
double TOTAL_USD,TOTAL_EUR,TOTAL_GBP,TOTAL_CHF,TOTAL_CAD,TOTAL_AUD,TOTAL_JPY;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   //---- indicator short name
   IndicatorShortName("Total Strength ");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----
   RefreshRates();

   HI_EURUSD = iHigh("EURUSD",1440,0); LO_EURUSD = iLow("EURUSD",1440,0); ASK_EURUSD = MarketInfo("EURUSD",MODE_ASK); BID_EURUSD = MarketInfo("EURUSD",MODE_BID);
   HI_GBPUSD = iHigh("GBPUSD",1440,0); LO_GBPUSD = iLow("GBPUSD",1440,0); ASK_GBPUSD = MarketInfo("GBPUSD",MODE_ASK); BID_GBPUSD = MarketInfo("GBPUSD",MODE_BID);
   HI_AUDUSD = iHigh("AUDUSD",1440,0); LO_AUDUSD = iLow("AUDUSD",1440,0); ASK_AUDUSD = MarketInfo("AUDUSD",MODE_ASK); BID_AUDUSD = MarketInfo("AUDUSD",MODE_BID);
   HI_USDJPY = iHigh("USDJPY",1440,0); LO_USDJPY = iLow("USDJPY",1440,0); ASK_USDJPY = MarketInfo("USDJPY",MODE_ASK); BID_USDJPY = MarketInfo("USDJPY",MODE_BID);
   HI_USDCHF = iHigh("USDCHF",1440,0); LO_USDCHF = iLow("USDCHF",1440,0); ASK_USDCHF = MarketInfo("USDCHF",MODE_ASK); BID_USDCHF = MarketInfo("USDCHF",MODE_BID);
   HI_USDCAD = iHigh("USDCAD",1440,0); LO_USDCAD = iLow("USDCAD",1440,0); ASK_USDCAD = MarketInfo("USDCAD",MODE_ASK); BID_USDCAD = MarketInfo("USDCAD",MODE_BID);
   HI_EURJPY = iHigh("EURJPY",1440,0); LO_EURJPY = iLow("EURJPY",1440,0); ASK_EURJPY = MarketInfo("EURJPY",MODE_ASK); BID_EURJPY = MarketInfo("EURJPY",MODE_BID);
   HI_EURGBP = iHigh("EURGBP",1440,0); LO_EURGBP = iLow("EURGBP",1440,0); ASK_EURGBP = MarketInfo("EURGBP",MODE_ASK); BID_EURGBP = MarketInfo("EURGBP",MODE_BID);
   HI_EURCHF = iHigh("EURCHF",1440,0); LO_EURCHF = iLow("EURCHF",1440,0); ASK_EURCHF = MarketInfo("EURCHF",MODE_ASK); BID_EURCHF = MarketInfo("EURCHF",MODE_BID);
   HI_EURAUD = iHigh("EURAUD",1440,0); LO_EURAUD = iLow("EURAUD",1440,0); ASK_EURAUD = MarketInfo("EURAUD",MODE_ASK); BID_EURAUD = MarketInfo("EURAUD",MODE_BID);
   HI_GBPJPY = iHigh("GBPJPY",1440,0); LO_GBPJPY = iLow("GBPJPY",1440,0); ASK_GBPJPY = MarketInfo("GBPJPY",MODE_ASK); BID_GBPJPY = MarketInfo("GBPJPY",MODE_BID);
   HI_GBPCHF = iHigh("GBPCHF",1440,0); LO_GBPCHF = iLow("GBPCHF",1440,0); ASK_GBPCHF = MarketInfo("GBPCHF",MODE_ASK); BID_GBPCHF = MarketInfo("GBPCHF",MODE_BID);
   
   RANGE_EURUSD = (HI_EURUSD-LO_EURUSD)*10000; RANGE_GBPUSD = (HI_GBPUSD-LO_GBPUSD)*10000; 
   RANGE_AUDUSD = (HI_AUDUSD-LO_AUDUSD)*10000; RANGE_USDJPY = (HI_USDJPY-LO_USDJPY)*100; 
   RANGE_USDCHF = (HI_USDCHF-LO_USDCHF)*10000; RANGE_USDCAD = (HI_USDCAD-LO_USDCAD)*10000; 
   RANGE_EURJPY = (HI_EURJPY-LO_EURJPY)*100;   RANGE_EURGBP = (HI_EURGBP-LO_EURGBP)*10000; 
   RANGE_EURCHF = (HI_EURCHF-LO_EURCHF)*10000; RANGE_EURAUD = (HI_EURAUD-LO_EURAUD)*10000; 
   RANGE_GBPJPY = (HI_GBPJPY-LO_GBPJPY)*100;   RANGE_GBPCHF = (HI_GBPCHF-LO_GBPCHF)*10000;    
   
   BIDRATIO_EURUSD = (BID_EURUSD-LO_EURUSD)/RANGE_EURUSD*10000;
   BIDRATIO_GBPUSD = (BID_GBPUSD-LO_GBPUSD)/RANGE_GBPUSD*10000; 
   BIDRATIO_AUDUSD = (BID_AUDUSD-LO_AUDUSD)/RANGE_AUDUSD*10000;
   BIDRATIO_USDJPY = (BID_USDJPY-LO_USDJPY)/RANGE_USDJPY*100;
   BIDRATIO_USDCHF = (BID_USDCHF-LO_USDCHF)/RANGE_USDCHF*10000;
   BIDRATIO_USDCAD = (BID_USDCAD-LO_USDCAD)/RANGE_USDCAD*10000;
   BIDRATIO_EURJPY = (BID_EURJPY-LO_EURJPY)/RANGE_EURJPY*100;
   BIDRATIO_EURGBP = (BID_EURGBP-LO_EURGBP)/RANGE_EURGBP*10000;
   BIDRATIO_EURCHF = (BID_EURCHF-LO_EURCHF)/RANGE_EURCHF*10000;
   BIDRATIO_EURAUD = (BID_EURAUD-LO_EURAUD)/RANGE_EURAUD*10000;
   BIDRATIO_GBPJPY = (BID_GBPJPY-LO_GBPJPY)/RANGE_GBPJPY*100;
   BIDRATIO_GBPCHF = (BID_GBPCHF-LO_GBPCHF)/RANGE_GBPCHF*10000;
   
   REL_EURUSD = CalcRelativeStrength(BIDRATIO_EURUSD);
   REL_GBPUSD = CalcRelativeStrength(BIDRATIO_GBPUSD);   
   REL_AUDUSD = CalcRelativeStrength(BIDRATIO_AUDUSD);
   REL_USDJPY = CalcRelativeStrength(BIDRATIO_USDJPY);
   REL_USDCHF = CalcRelativeStrength(BIDRATIO_USDCHF);
   REL_USDCAD = CalcRelativeStrength(BIDRATIO_USDCAD);
   REL_EURJPY = CalcRelativeStrength(BIDRATIO_EURJPY);
   REL_EURGBP = CalcRelativeStrength(BIDRATIO_EURGBP);
   REL_EURCHF = CalcRelativeStrength(BIDRATIO_EURCHF);
   REL_EURAUD = CalcRelativeStrength(BIDRATIO_EURAUD);
   REL_GBPJPY = CalcRelativeStrength(BIDRATIO_GBPJPY);
   REL_GBPCHF = CalcRelativeStrength(BIDRATIO_GBPCHF);
   
   REL2_EURUSD = 9-REL_EURUSD;
   REL2_GBPUSD = 9-REL_GBPUSD;
   REL2_AUDUSD = 9-REL_AUDUSD;
   REL2_USDJPY = 9-REL_USDJPY;
   REL2_USDCHF = 9-REL_USDCHF;
   REL2_USDCAD = 9-REL_USDCAD;
   REL2_EURJPY = 9-REL_EURJPY;
   REL2_EURGBP = 9-REL_EURGBP;
   REL2_EURCHF = 9-REL_EURCHF;
   REL2_EURAUD = 9-REL_EURAUD;
   REL2_GBPJPY = 9-REL_GBPJPY;
   REL2_GBPCHF = 9-REL_GBPCHF;
   
   TOTAL_USD = NormalizeDouble((REL_USDJPY+REL_USDCHF+REL_USDCAD+REL2_EURUSD+REL2_GBPUSD+REL2_AUDUSD)/6,1);
   TOTAL_EUR = NormalizeDouble((REL_EURUSD+REL_EURJPY+REL_EURGBP+REL_EURCHF+REL_EURAUD)/5,1);
   TOTAL_GBP = NormalizeDouble((REL_GBPUSD+REL_GBPJPY+REL_GBPCHF+REL2_EURGBP)/4,1);
   TOTAL_CHF = NormalizeDouble((REL2_USDCHF+REL2_EURCHF+REL2_GBPCHF)/3,1);
   TOTAL_CAD = NormalizeDouble((REL2_USDCAD),1);
   TOTAL_AUD = NormalizeDouble((REL_AUDUSD+REL2_EURAUD)/2,1);
   TOTAL_JPY = NormalizeDouble((REL2_USDJPY+REL2_EURJPY+REL2_GBPJPY)/3,1);  
   
   //---- create text "Getting: "
   ObjectCreate("TotalS-3b",OBJ_LABEL, 0, 0, 0);
     ObjectSetText("TotalS-3b",Description, 8, "Arial Bold", LightSteelBlue);
     ObjectSet("TotalS-3b", OBJPROP_CORNER, 2);
     ObjectSet("TotalS-3b", OBJPROP_XDISTANCE, PositionFromleft);
     ObjectSet("TotalS-3b", OBJPROP_YDISTANCE, 6);   
   ObjectCreate("TotalS-1e",OBJ_LABEL, 0, 0, 0);
     ObjectSet("TotalS-1e", OBJPROP_CORNER, 2);
     ObjectSet("TotalS-1e", OBJPROP_XDISTANCE, PositionFromleft+100);
     ObjectSet("TotalS-1e", OBJPROP_YDISTANCE, 6);
     if (TOTAL_USD > 7) 
     { ObjectSetText("TotalS-1e", " USD "+DoubleToStr(TOTAL_USD,1),8, "Arial Bold",Red); } else
     if (TOTAL_USD >= 5 && TOTAL_USD <=7) 
     { ObjectSetText("TotalS-1e", " USD "+DoubleToStr(TOTAL_USD,1),8, "Arial Bold",Gold); } else
     if (TOTAL_USD <= 2) 
     { ObjectSetText("TotalS-1e", " USD "+DoubleToStr(TOTAL_USD,1),8, "Arial Bold",Blue); } else
     { ObjectSetText("TotalS-1e", " USD "+DoubleToStr(TOTAL_USD,1),8, "Arial Bold",Silver); }
        
   ObjectCreate("TotalS-2e",OBJ_LABEL, 0, 0, 0);
     ObjectSet("TotalS-2e", OBJPROP_CORNER, 2);
     ObjectSet("TotalS-2e", OBJPROP_XDISTANCE, PositionFromleft+150);
     ObjectSet("TotalS-2e", OBJPROP_YDISTANCE, 6);
     if (TOTAL_EUR > 7) 
     { ObjectSetText("TotalS-2e", " EUR "+DoubleToStr(TOTAL_EUR,1),8, "Arial Bold",Red); } else
     if (TOTAL_EUR >= 5 && TOTAL_EUR <=7) 
     { ObjectSetText("TotalS-2e", " EUR "+DoubleToStr(TOTAL_EUR,1),8, "Arial Bold",Gold); } else
     if (TOTAL_EUR <= 2) 
     { ObjectSetText("TotalS-2e", " EUR "+DoubleToStr(TOTAL_EUR,1),8, "Arial Bold",Blue); } else
     { ObjectSetText("TotalS-2e", " EUR "+DoubleToStr(TOTAL_EUR,1),8, "Arial Bold",Silver); }

   ObjectCreate("TotalS-3e",OBJ_LABEL, 0, 0, 0);
     ObjectSet("TotalS-3e", OBJPROP_CORNER, 2);
     ObjectSet("TotalS-3e", OBJPROP_XDISTANCE, PositionFromleft+200);
     ObjectSet("TotalS-3e", OBJPROP_YDISTANCE, 6);
     if (TOTAL_GBP > 7) 
     { ObjectSetText("TotalS-3e", " GBP "+DoubleToStr(TOTAL_GBP,1),8, "Arial Bold",Red); } else
     if (TOTAL_GBP >= 5 && TOTAL_GBP <=7) 
     { ObjectSetText("TotalS-3e", " GBP "+DoubleToStr(TOTAL_GBP,1),8, "Arial Bold",Gold); } else
     if (TOTAL_GBP <= 2) 
     { ObjectSetText("TotalS-3e", " GBP "+DoubleToStr(TOTAL_GBP,1),8, "Arial Bold",Blue); } else
     { ObjectSetText("TotalS-3e", " GBP "+DoubleToStr(TOTAL_GBP,1),8, "Arial Bold",Silver); }
     
   ObjectCreate("TotalS-4e",OBJ_LABEL, 0, 0, 0);
     ObjectSet("TotalS-4e", OBJPROP_CORNER, 2);
     ObjectSet("TotalS-4e", OBJPROP_XDISTANCE, PositionFromleft+250);
     ObjectSet("TotalS-4e", OBJPROP_YDISTANCE, 6);
     if (TOTAL_CHF > 7) 
     { ObjectSetText("TotalS-4e", " CHF "+DoubleToStr(TOTAL_CHF,1),8, "Arial Bold",Red); } else
     if (TOTAL_CHF >= 5 && TOTAL_CHF <=7) 
     { ObjectSetText("TotalS-4e", " CHF "+DoubleToStr(TOTAL_CHF,1),8, "Arial Bold",Gold); } else
     if (TOTAL_CHF <= 2) 
     { ObjectSetText("TotalS-4e", " CHF "+DoubleToStr(TOTAL_CHF,1),8, "Arial Bold",Blue); } else
     { ObjectSetText("TotalS-4e", " CHF "+DoubleToStr(TOTAL_CHF,1),8, "Arial Bold",Silver); }     
       
   ObjectCreate("TotalS-5e",OBJ_LABEL, 0, 0, 0);
     ObjectSet("TotalS-5e", OBJPROP_CORNER, 2);
     ObjectSet("TotalS-5e", OBJPROP_XDISTANCE, PositionFromleft+300);
     ObjectSet("TotalS-5e", OBJPROP_YDISTANCE, 6);
     if (TOTAL_CAD > 7) 
     { ObjectSetText("TotalS-5e", " CAD "+DoubleToStr(TOTAL_CAD,1),8, "Arial Bold",Red); } else
     if (TOTAL_CAD >= 5 && TOTAL_CAD <=7) 
     { ObjectSetText("TotalS-5e", " CAD "+DoubleToStr(TOTAL_CAD,1),8, "Arial Bold",Gold); } else
     if (TOTAL_CAD <= 2) 
     { ObjectSetText("TotalS-5e", " CAD "+DoubleToStr(TOTAL_CAD,1),8, "Arial Bold",Blue); } else
     { ObjectSetText("TotalS-5e", " CAD "+DoubleToStr(TOTAL_CAD,1),8, "Arial Bold",Silver); }      
    
   ObjectCreate("TotalS-6e",OBJ_LABEL, 0, 0, 0);
     ObjectSet("TotalS-6e", OBJPROP_CORNER, 2);
     ObjectSet("TotalS-6e", OBJPROP_XDISTANCE, PositionFromleft+350);
     ObjectSet("TotalS-6e", OBJPROP_YDISTANCE, 6);
     if (TOTAL_AUD > 7) 
     { ObjectSetText("TotalS-6e", " AUD "+DoubleToStr(TOTAL_AUD,1),8, "Arial Bold",Red); } else
     if (TOTAL_AUD >= 5 && TOTAL_AUD <=7) 
     { ObjectSetText("TotalS-6e", " AUD "+DoubleToStr(TOTAL_AUD,1),8, "Arial Bold",Gold); } else
     if (TOTAL_AUD <= 2) 
     { ObjectSetText("TotalS-6e", " AUD "+DoubleToStr(TOTAL_AUD,1),8, "Arial Bold",Blue); } else
     { ObjectSetText("TotalS-6e", " AUD "+DoubleToStr(TOTAL_AUD,1),8, "Arial Bold",Silver); }     
     
   ObjectCreate("TotalS-7e",OBJ_LABEL, 0, 0, 0);
     ObjectSet("TotalS-7e", OBJPROP_CORNER, 2);
     ObjectSet("TotalS-7e", OBJPROP_XDISTANCE, PositionFromleft+400);
     ObjectSet("TotalS-7e", OBJPROP_YDISTANCE, 6);
     if (TOTAL_JPY > 7) 
     { ObjectSetText("TotalS-7e", " JPY "+DoubleToStr(TOTAL_JPY,1),8, "Arial Bold",Red); } else
     if (TOTAL_JPY >= 5 && TOTAL_JPY <=7) 
     { ObjectSetText("TotalS-7e", " JPY "+DoubleToStr(TOTAL_JPY,1),8, "Arial Bold",Gold); } else
     if (TOTAL_JPY <= 2) 
     { ObjectSetText("TotalS-7e", " JPY "+DoubleToStr(TOTAL_JPY,1),8, "Arial Bold",Blue); } else
     { ObjectSetText("TotalS-7e", " JPY "+DoubleToStr(TOTAL_JPY,1),8, "Arial Bold",Silver); }                   
   
//----
   return(0);
  }
//+------------------------------------------------------------------+

int CalcRelativeStrength(double RelativeStrength)
{
  if (NormalizeDouble((RelativeStrength*100),0) < 3 ) return (0); else
  if (NormalizeDouble((RelativeStrength*100),0) < 10 ) return (1); else
  if (NormalizeDouble((RelativeStrength*100),0) < 25 ) return (2); else
  if (NormalizeDouble((RelativeStrength*100),0) < 40 ) return (3); else
  if (NormalizeDouble((RelativeStrength*100),0) < 50 ) return (4); else
  if (NormalizeDouble((RelativeStrength*100),0) < 60 ) return (5); else
  if (NormalizeDouble((RelativeStrength*100),0) < 75 ) return (6); else
  if (NormalizeDouble((RelativeStrength*100),0) < 90 ) return (7); else
  if (NormalizeDouble((RelativeStrength*100),0) < 97 ) return (8); else
  if (NormalizeDouble((RelativeStrength*100),0) >= 97 ) return (9);    
}
//+------------------------------------------------------------------+

